
package edu.unl.consystlab.gui;

import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

class LafMenuItemListener implements ActionListener
{
	private LookAndFeelInfo lif;
	private JFrame jframe;

	public LafMenuItemListener(LookAndFeelInfo lif, JFrame jframe)
	{
		this.lif = lif;
		this.jframe = jframe;
	}

	public void actionPerformed(ActionEvent e)
	{
		try
		{
			UIManager.setLookAndFeel(lif.getClassName());
		}
		catch (Exception ex)
		{
			try
			{
				String[] err = new String[3];
				err[0] = "Cannot set the Look&Feel to";
				err[1] = "'" + lif.getName() + "': ";
				err[2] = ex.toString();
				JOptionPane.showMessageDialog(
					null,
					err,
					"Could not set the Look&Feel",
					JOptionPane.PLAIN_MESSAGE);
			}
			catch (Exception z)
			{
				System.err.println(
					"showMessageDialog for failure of UIManager.setLookAndFeel() failed");
			}
			return;
		}
		// u find this is a howto!! ???
		//SwingUtilities.updateComponentTreeUI(jframe.getRootPane());
		//SwingUtilities.updateComponentTreeUI(jframe.getGlassPane());
		SwingUtilities.updateComponentTreeUI(jframe.getJMenuBar());
		SwingUtilities.updateComponentTreeUI(jframe.getContentPane());
		jframe.pack();
	}
} // LafMenuListener()

public class LafMenu extends JMenu
{
	private String currentLaf;
	public LafMenu(JFrame f)
	{
		super("Look&Feel");
		currentLaf = UIManager.getSystemLookAndFeelClassName();
		LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
		ButtonGroup bgroup = new ButtonGroup();
		for (int i = 0; i < laf.length; i++)
		{
			Button testButton = new Button();
			boolean b =
				(laf[i].getClassName().equals(currentLaf) ? true : false);
			JRadioButtonMenuItem item =
				new JRadioButtonMenuItem(laf[i].getName(), b);
			bgroup.add(item);
			this.add(item);
			item.addActionListener(new LafMenuItemListener(laf[i], f));
			/* check if this LAF will work later on
			try
			{
				UIManager.setLookAndFeel(laf[i].getClassName());
				item.setEnabled(true);
			}
			catch (Exception ex)
			{
				item.setEnabled(false);
			}
			*/
		} // for all lads
		/*	DO revert to default LAF since the above might have messed things up.
		try
		{
			UIManager.setLookAndFeel(currentLaf);
			//SwingUtilities.updateComponentTreeUI(f.getJMenuBar());
			SwingUtilities.updateComponentTreeUI(f.getContentPane());
			f.pack();
		}
		catch (Exception ex)
		{
		}
		*/
	}
}
